' Manic Miner - Files to Upper EEPROM ported to Propeller Chip By Jim Bagley 
'

CON

'uncomment the '{ block which suites your system.
'{ Hydra Defines
        _CLKMODE                = xtal1 + pll8x
        _XINFREQ                = 10_000_000 + 0000

USE_TV_ON_PIN_24               = 1      ' usually 0 for Proto/Demo boards ( JBSpecGfx.Start(12) ) and 1 for Hydra ( JBSpecGfx.Start(24) ) 
'}
{ Proto/Demoboard Defines - No SD card installed
        _CLKMODE                = xtal1 + pll16x
        _XINFREQ                = 5_000_000 + 0000

USE_TV_ON_PIN_24               = 0      ' usually 0 for Proto/Demo boards ( JBSpecGfx.Start(12) ) and 1 for Hydra ( JBSpecGfx.Start(24) ) 
'}
{ Proto/Demoboard Defines - SD card installed on pin 0-3
        _CLKMODE                = xtal1 + pll16x
        _XINFREQ                = 5_000_000 + 0000

USE_TV_ON_PIN_24               = 0      ' usually 0 for Proto/Demo boards ( JBSpecGfx.Start(12) ) and 1 for Hydra ( JBSpecGfx.Start(24) ) 
'}

VAR
  long  VSync

  long  txtx,txty,txtcol  

  long  ptr
  long  eepromAddress

OBJ
  Spectrum      : "JB_002_JLC_Spectrum_TV_010"
  i2c           : "Basic_I2C_Driver"    'EEPROM Driver

PUB Start | x,y,i,j

  Spectrum.Start(@Screen, 0, @VSync, USE_TV_ON_PIN_24)
  
  eepromAddress:=$8000
  'start eeprom driver
  i2c.Initialize(28)

  ptr:=@levels
  repeat while ((ptr&$ffe0)<@endoffile)
    writei2c(ptr, eepromAddress, 32)
    eepromAddress+=32
    ptr+=32    

  eepromAddress:=$8000
  ptr:=@levels
  repeat while ((ptr&$ffe0)<@endoffile)
    readi2c(ptr, eepromAddress, 32)
    eepromAddress+=32
    ptr+=32    

  repeat y from 0 to 127
    readi2c(@Screen+((y&7)<<8)+((y&$38)<<2)+((y&64)<<5), $D000+(y*32), 32)
  repeat y from 0 to 15
    readi2c(@Screen+6144+(y<<5), $E000+(y*32), 32)

  longfill(@Screen+6144+512,0,256/4)

  print(@donetext,14,20,$47)
  repeat

pub readi2c(buffer,eepromaddr,size)
   if i2c.ReadPage(i2c#BootPin, i2c#EEPROM, eepromaddr, buffer, size)
        abort ' an error occurred during the read

pub writei2c(buffer,eepromaddr,size) | startTime
   if i2c.WritePage(i2c#BootPin, i2c#EEPROM, eepromaddr, buffer, size)
     abort ' an error occured during the write
   startTime := cnt ' prepare to check for a timeout
   repeat while i2c.WriteWait(i2c#BootPin, i2c#EEPROM, eepromaddr)
     if cnt - startTime > clkfreq / 10
       abort ' waited more than a 1/10 second for the write to finish

PUB print(p,x,y,col)
  txtx:=x
  txty:=y
  txtcol:=col
  repeat while byte[p][0]<>0
    print_char(byte[p][0])
    p++    

PUB print_char(p) | y
  repeat y from 0 to 7
    Screen[(((txty<<3)+y)<<5)+txtx]:=font[(p-32)<<3+y]
  Screen[6144+(txty<<5)+txtx]:=txtcol
  txtx++
  if txtx>31
    txtx:=0
    if txty<24
      txty++

DAT

font    file  "SpectrumFont.bin"
donetext      byte      "Done",0,0,0,0
errortext     byte      "Error!!",0

hex     byte  "0123456789ABCDEF"

Screen  byte   ' this is the start or memory transfered to $8000
levels        file  "mmlevels.bin"
TitleScr      file  "titlescr.bin"
TitleAttr     file  "titleatr.bin"

endoffile     long  0